<?php
// Initialize the session

session_start();
// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: https://street.menforhealth.org/bame/sign-in.php");
    exit;
}
?>



<!doctype html>
<html lang="en">


<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Admin</title>
     <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <link rel="icon" type="image/png" href="assets/img/favicon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Fira+Sans+Condensed:wght@100;400;500;600&amp;family=Roboto:ital,wght@0,300;0,400;0,500;0,700;1,400&amp;display=swap"
        rel="stylesheet">
    <style>
        :root {
            --adminuiux-content-font: 'Roboto';
            --adminuiux-content-font-weight: 400;
            --adminuiux-title-font: "Fira Sans Condensed";
            --adminuiux-title-font-weight: 500
        }
    </style>
    <script defer="defer" src="assets/js/app225d.js?a420ab3a19270efb30bb"></script>
    <link href="assets/css/app225d.css?a420ab3a19270efb30bb" rel="stylesheet">
</head>

<?
include "dbconnect.php"; // Using database connection file here
      $email = $_SESSION["email"];
?>

<body
    class="main-bg main-bg-opac main-bg-blur adminuiux-sidebar-fill-white adminuiux-sidebar-boxed theme-blue roundedui"
    data-theme="theme-blue" data-sidebarfill="adminuiux-sidebar-fill-white" data-bs-spy="scroll"
    data-bs-target="#list-example" data-bs-smooth-scroll="true" tabindex="0">
   <div class="pageloader">
        <div class="container h-100">
            <div class="row justify-content-center align-items-center text-center h-100">
                <div class="col-12 mb-auto pt-4"></div>
                <div class="col-auto"><img src="logo.png" alt="" class="height-60 mb-3">
                    <p class="h6 mb-0">Tuckshop</p>
                    <p class="h3 mb-4">Management</p>
                    <div class="loader10 mb-2 mx-auto"></div>
                </div>
                <div class="col-12 mt-auto pb-4">
                    <p class="text-secondary">Please wait...</p>
                </div>
            </div>
        </div>
    </div>
  <header class="adminuiux-header">
        <nav class="navbar navbar-expand-lg fixed-top">
            <div class="container-fluid"><button class="btn btn-link btn-square sidebar-toggler" type="button"
                    onclick="initSidebar()"><i class="sidebar-svg" data-feather="menu"></i></button> <a
                    class="navbar-brand" href="#"><img data-bs-img="light"
                        src="logo.png" alt=""> <img data-bs-img="dark" src="logo.png"
                        alt="">
                    <div class=""><span class="h5">Investment<b>UX</b></span>
                        <p class="fs-12 opacity-75">Mobile HTML template</p>
                    </div>
                </a>
                <div class="ms-auto"><button class="btn btn-link btn-square btn-icon btn-link-header" type="button"
                        onclick="openSearch()"><i data-feather="search"></i></button> 
                

                </div>
                                    <div class="dropdown d-inline-block"><a
                            class="dropdown-toggle btn btn-link btn-square btn-link-header style-none no-caret px-0"
                            id="userprofiledd" data-bs-toggle="dropdown" aria-expanded="false" role="button">
                            <div class="row gx-0 d-inline-flex">
                                <div class="col-auto align-self-center">
                                    <figure class="avatar avatar-28 rounded-circle coverimg align-middle"><img
                                            src="user.jpg" alt=""
                                            id="userphotoonboarding2"></figure>
                                </div>
                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end width-300 pt-0 px-0"
                            aria-labelledby="userprofiledd">
                            <div class="bg-theme-1-space rounded py-3 mb-3 dropdown-dontclose">
                                <div class="row gx-0">
                                    <div class="col-auto px-3">
                                        <figure class="avatar avatar-50 rounded-circle coverimg align-middle"><img
                                                src="user.jpg" alt=""></figure> 
                                    </div>
                                    <div class="col align-self-center">
                                        <p class="mb-1"><span>Tuckshop</span></p>
                     <?php

                       
                     

                       $records = mysqli_query($conn,"select * from users where email='$email'");


                       // fetch data from database

                       while($data = mysqli_fetch_array($records))
                       {
                       ?>
                                        <p><i class="bi bi-shop me-2"></i>Hello! <small
                                                class="opacity-50"><?php echo $data['first_name']; ?></small></p>
                                    </div>
                                </div>
                            </div>
                            <div class="px-2">
                                <div><a class="dropdown-item" href="investment-myprofile.php"><i data-feather="user"
                                            class="avatar avatar-18 me-1"></i> My Profile</a></div>
    


                                
                                <div><a class="dropdown-item" href="investment-settings.php"><i data-feather="settings"
                                            class="avatar avatar-18 me-1"></i> Account Setting</a></div>
                                <div><a class="dropdown-item theme-red" href="logout.php"><i
                                            data-feather="power" class="avatar avatar-18 me-1"></i> Logout</a></div>
                            </div>
                        </div>
                                  <?php
                    }
                    ?>
                    </div>
            </div>
        </nav>
        <div class="adminuiux-search-full">
            <div class="row gx-2 align-items-center">
                <div class="col-auto"><button class="btn btn-link btn-square" type="button" onclick="closeSearch()"><i
                            data-feather="arrow-left"></i></button></div>
                <div class="col"><input class="form-control pe-0 border-0" type="search"
                        placeholder="Type something here..."></div>
                
            </div>
        </div>
        
    </header>
    <div class="adminuiux-wrap">
         <!--  <div class="adminuiux-sidebar">
            <div class="adminuiux-sidebar-inner">
                <div class="px-3 not-iconic mt-2">
                    <div class="row gx-3">
                        <div class="col align-self-center">
                            <h6 class="fw-medium">Main Menu</h6>
                        </div>
                        <div class="col-auto"><a class="btn btn-link btn-square" data-bs-toggle="collapse"
                                data-bs-target="#usersidebarprofile" aria-expanded="false" role="button"
                                aria-controls="usersidebarprofile"><i data-feather="user"></i></a></div>
                    </div>
                    <div class="text-center collapse" id="usersidebarprofile">
                        <figure class="avatar avatar-100 rounded-circle coverimg my-3"><img
                                src="assets/img/modern-ai-image/user-6.jpg" alt=""></figure>
                        <h5 class="mb-1 fw-medium">AdminUIUX</h5>
                        <p class="small">The Investment UI Kit</p>
                    </div>
                </div>
                <ul class="nav flex-column menu-active-line">
                    <li class="nav-item"><a href="investment-dashboard.html" class="nav-link"><i
                                class="menu-icon bi bi-columns-gap"></i> <span class="menu-name">Dashboard</span></a>
                    </li>
                    <li class="nav-item"><a href="investment-wallet.html" class="nav-link"><i
                                class="menu-icon bi bi-wallet"></i> <span class="menu-name">Wallet</span></a></li>
                    <li class="nav-item"><a href="investment-goals.html" class="nav-link"><i
                                class="menu-icon bi bi-bullseye"></i> <span class="menu-name">My Goals</span></a></li>
                    <li class="nav-item"><a href="investment-loan-list.html" class="nav-link"><i
                                class="menu-icon bi bi-bank"></i> <span class="menu-name">My Loans</span></a></li>
                    <li class="nav-item dropdown"><a href="javascrit:void(0)" class="nav-link dropdown-toggle"
                            data-bs-toggle="dropdown"><i class="menu-icon bi bi-piggy-bank"></i> <span
                                class="menu-name">Investment</span></a>
                        <div class="dropdown-menu">
                            <div class="nav-item"><a href="investment-company-shares.html" class="nav-link"><i
                                        class="menu-icon bi bi-bank"></i> <span class="menu-name">Company
                                        Share</span></a></div>
                            <div class="nav-item"><a href="investment-mutual-funds.html" class="nav-link"><i
                                        class="menu-icon bi bi-cash-coin"></i> <span class="menu-name">Mutual
                                        Fund</span></a></div>
                            <div class="nav-item"><a href="investment-deposit.html" class="nav-link"><i
                                        class="menu-icon bi bi-percent"></i> <span class="menu-name">Deposit</span></a>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item"><a href="investment-explore.html" class="nav-link"><i
                                class="menu-icon bi bi-search"></i> <span class="menu-name">Explore</span></a></li>
                    <li class="nav-item"><a href="investment-statistics.html" class="nav-link"><i
                                class="menu-icon bi bi-bar-chart-line"></i> <span
                                class="menu-name">Statistics</span></a></li>
                    <li class="nav-item"><a href="investment-calculator.html" class="nav-link"><i
                                class="menu-icon bi bi-calculator"></i> <span class="menu-name">Calculators</span></a>
                    </li>
                    <li class="nav-item"><a href="investment-pages.html" class="nav-link"><i
                                class="menu-icon bi bi-layers"></i> <span class="menu-name">Pages</span> <span
                                class="badge text-bg-primary mx-2">40+</span></a></li>
                    <li class="nav-item"><a href="investment-personalization.html" class="nav-link"><i
                                class="menu-icon bi bi-palette h4"></i> <span class="menu-name">Personalize
                                ❤️</span></a></li>
                    <li class="nav-item"><a class="nav-link" href="components.html"><i class="menu-icon bi bi-cpu"></i>
                            <span class="menu-name">Components</span></a></li>
                </ul>
                <div class="mt-auto"></div>
                <div class="px-3 mb-3 not-iconic">
                    <h6 class="mb-3 fw-medium">Quick Links</h6>
                    <div class="card adminuiux-card">
                        <div class="card-body p-2">
                            <div class="row gx-2">
                                <div class="col-12 d-flex justify-content-between"><a
                                        href="investment-search-mutual-funds.html"
                                        class="btn btn-square btn-link theme-red"><span class="position-relative"><i
                                                data-feather="heart"></i> <span
                                                class="position-absolute top-0 start-100 translate-middle p-1 bg-success rounded-circle"><span
                                                    class="visually-hidden">New alerts</span> </span></span></a><a
                                        href="investment-schedule.html" class="btn btn-square btn-link"><span
                                            class="position-relative"><i data-feather="calendar"></i> <span
                                                class="position-absolute top-0 start-100 translate-middle p-1 bg-warning rounded-circle"><span
                                                    class="visually-hidden">New alerts</span> </span></span></a><a
                                        href="investment-inbox.html" class="btn btn-square btn-link"><i
                                            data-feather="inbox"></i> </a><a href="investment-help-center.html"
                                        class="btn btn-square btn-link"><i data-feather="help-circle"></i></a></div>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="nav flex-column menu-active-line">
                    <li class="nav-item"><a href="investment-referral.html" class="nav-link"><i class="menu-icon"
                                data-feather="users"></i> <span class="menu-name">Referral</span></a></li>
                    <li class="nav-item"><a href="investment-settings.html" class="nav-link"><i class="menu-icon"
                                data-feather="settings"></i> <span class="menu-name">Settings</span></a></li>
                </ul>
            </div>
        </div> -->
        <main class="adminuiux-content has-sidebar" onclick="contentClick()">
            <div class="container-fluid mt-3">
                <div class="row gx-3 align-items-center">
                    <div class="col col-sm">
                        <h5>TuckShop Reports</h5>
                    </div>
                    <div class="col-auto"><input class="form-control form-control-sm d-inline-block w-auto align-middle"
                            id="daterangepickerranges"> <button
                            class="btn btn-sm btn-square btn-theme d-none d-sm-inline-block"
                            onclick="$(this).prev().click()"><i data-feather="calendar"></i></button></div>
                </div>
            </div>
            <div class="container mt-3" id="main-content">
                <div class="row gx-3">
                   
                
                  
                 
                   
                   
                    <div class="col-12 col-lg-6 col-xl-4 mb-3">
                        
                        <div class="card adminuiux-card">
                            <div class="card-header">
                                <h6>My Inventory</h6>
                            </div>
                             <?php

                       include "dbconnect.php"; // Using database connection file here
                      

                       $records = mysqli_query($conn,"select * from inventory where email='$email' order by quantity desc");

                       // fetch data from database

                     
                          while($data = mysqli_fetch_array($records))
                       {
                           $itemId = $data['id'];
                           $quant = $data['quantity'];
                           $price = $data['unit_price'];
                           
                       

                     
                           ?>
                       
                           <ul class="list-group list-group-flush border-top bg-none">
                                <li class="list-group-item">
                                    <div class="row gx-3 align-items-center">
                                        <div class="col-auto"><i
                                                class="bi bi-building-lock avatar avatar-40 h5 rounded-circle border"></i>
                                        </div>
                                        <div class="col">
                                            <p class="mb-1 fw-medium"><?echo $data['product_name'];?></p>
                                            <p class="small text-secondary"><?echo "BWP ". $data['unit_price'] ." : ".    $data['quantity']; ?>Units</p>
                                        </div>
                                        <?
                                        $record = mysqli_query($conn,"select sum(credit_amount) as amount from credit_transactions where itemId='$itemId'");
                                        $percentage = 0;
                                        $Tsales =0;
                                        while($dat = mysqli_fetch_array($record))
                                            {
                                                $amount = $dat['amount'];
                                                $sales = $amount / $price;
                                                $Tsales = $price * $sales;
                                                $projection = $sales + $quant;
                                                $percentage = ($sales/$projection) * 100;
                                            }
                                                ?>
                                               
                                        <div class="col-auto text-end">
                                            <h6><?echo "P ". $Tsales?></h6>
                                            <p class="small text-success"><i class="bi bi-caret-up-fill"></i> <?echo
                                            round($percentage,0) ?>%</p>
                                        </div>
                                        
                                    </div>
                                </li>
                               
                               
                                
                               
                            </ul>
                                <?
                     
                     }
                    ?>
                        
                           
                           
                          
                        </div>
                    </div>
                  
                    
                    
                    
                   
                    <div class="col-12 col-lg-6 col-xl-4 mb-3">
                        <div class="card adminuiux-card">
                            <div class="card-header">
                                <h6>Shop Performance</h6>
                            </div>
                            <div class="card-body">
                                <div class="text-center mb-3">
                                    <h5>Moderate</h5>
                                    <p class="text-secondary small">Your Tuckshop in good situation</p>
                                </div>
                                <div class="riskometer moderate mb-3">
                                    <div class="indicator"></div>
                                </div><br>
                                <?
                                $recor = mysqli_query($conn,"select sum(credit_amount) as amoun 
                                from credit_transactions
                                where credit_transactions.bmail = '$email'");
                                      
                                       $Total = 0;
                                        while($da = mysqli_fetch_array($recor))
                                            {
                                                $Total = $da['amoun'];
                                             
                                                
                                            } 
                                            
                                            $reco = mysqli_query($conn,"select sum(total_cost)as total 
                                from inventory
                                where inventory.email = '$email'");
                                       
                                       $Totals = 0;
                                        while($datas = mysqli_fetch_array($reco))
                                            {
                                                $Totals = $datas['total'];
                                             
                                                
                                            } 
                                            
                                            $percent = ($Total/$Totals)*100;
                                           
                                ?>
                                <div class="text-center">
                                    <h4 class="fw-medium"><? echo "BWP". $Total; ?>  <span class="text-success fs-14"><i
                                                class="bi bi-arrow-up-short me-1"></i> <? echo round($percent,0);?>%</span></h4>
                                    <p class="text-secondary">Profit Revenue</p>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <footer class="adminuiux-mobile-footer hide-on-scrolldown style-2">
                <div class="container">
                    <ul class="nav nav-pills nav-justified">
                        <li class="nav-item"><a class="nav-link" href="index.php"><span><i
                                        class="nav-icon" data-feather="home"></i> <span
                                        class="nav-text">Home</span></span></a></li>
                        <li class="nav-item"><a class="nav-link" href="reports.php"><span><i class="nav-icon"
                                        data-feather="calendar"></i> <span class="nav-text">Reports</span></span></a>
                        </li>
                        <li class="nav-item"><a href="inventory.php" class="nav-link"><span><i class="nav-icon"
                                        data-feather="target"></i> <span class="nav-text">Inventory</span></span></a></li>
                        <li class="nav-item"><a class="nav-link" href="#"><span><i
                                        class="nav-icon" data-feather="users"></i> <span
                                        class="nav-text">Sales</span></span></a></li>
                        <li class="nav-item"><a class="nav-link" href="investment-settings.php"><span><i
                                        class="nav-icon bi bi-gear"></i> <span
                                        class="nav-text">Settings</span></span></a></li>
                    </ul>
                </div>
            </footer>
        </main>
    </div>
 
    <script src="assets/js/investment/investment-statistics.js"></script>
</body>
<!-- Mirrored from adminuiux.com/adminuiux/investment-mobile-uiux/investment-statistics.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 17 Mar 2025 07:52:36 GMT -->

</html>